/** re-useable package for java-based DDC clients */ 
package de.dwds.ddc.client;

import java.io.*;
import java.net.*;
import org.json.*; 

/** top-level class for java-based DDC clients */
public class DDCClient extends DDCSocket {
	//-----------------------------------------------------------------
	// constants

	/** DDCClient library version */
	static final String VERSION = "0.0.2";
	
	//-----------------------------------------------------------------
	// constructors etc
	/** default constructor */
	public DDCClient()
	{
		super();
	}
	
	/** constructor given host and port */
	public DDCClient(String host, int port)
	{
		super(host, port);
	}

	/** constructor given host, port, and timeout */
	public DDCClient(String host, int port, int timeout_ms)
	{
		super(host, port, timeout_ms);
	}

	//-----------------------------------------------------------------
	// high-level API
	
	/** high-level method for querying a distributed DDC-2.x server */
	public DDCQueryResponse runQuery(String queryStr, int offset, int limit, int timeout_s)
			throws IOException, JSONException
	{	
		String qstr = ("run_query Distributed"
				+ (char)0x01 + queryStr
				+ (char)0x01 + "json"
				+ (char)0x01 + offset + " " + limit + " " + timeout_s
				);
		setTimeout(timeout_s*1000);
		byte[] buf = request(qstr.getBytes());
		return new DDCQueryResponse(new String(buf));
	}

	/** generic wrapper for requests with JSON responses 
	 * @throws IOException, JSONException */
	public JSONObject requestJson(String req) throws IOException, JSONException
	{ return new JSONObject( this.request(req) ); }
	
	/** get server status as a JSONObject */
	public JSONObject statusJson() throws IOException, JSONException
	{ return requestJson("status"); }
	
	/** get verbsose server status as a JSONObject */
	public JSONObject vstatusJson() throws IOException, JSONException
	{ return requestJson("vstatus"); }
	
	/** get information on server index as a JSONObject */
	public JSONObject infoJson() throws IOException, JSONException
	{ return requestJson("info"); }
}
