package de.dwds.ddc.client;

import java.util.*;
import org.json.*;

/** class representing a single hit returned by a ddc-2.x server */
public class DDCHit extends DDCJsonObject {
	//-----------------------------------------------------------------
	// properties (all public, because private data is annoying)
	
	/** hit metadata */
    public HashMap<String,String> meta_;
    
    /** names of returned token index fields */
	public String[]           indices_;
	
	/** map index field names to positions */
	public HashMap<String,Integer> index_;
	
	/** left extra-sentential context (default (text) attribute only) */
	public String[]           left_;   
	
	/** matched sentence */
	public DDCHitToken[]	  match_;
	
	/** left extra-sentential context (default (text) attribute only) */
	public String[]           right_;
	
	//-----------------------------------------------------------------
	// constructors etc		
	/** default constructor */
	DDCHit() {
		super();
		meta_ = null;
		indices_ = null;
		index_ = null;
		left_ = null;
		match_ = null;
		right_ = null;
	}

	/** constructor from json string */
	DDCHit(String jsonStr) throws JSONException
	{ super(jsonStr); }

	/** constructor from json object */
	DDCHit(JSONObject jsonObj) throws JSONException
	{ super(jsonObj); }

	// -----------------------------------------------------------------
	// parsing

	/** populate object by parsing ddc-2.x json response object */
	public void fromJson(JSONObject jsonObj) throws JSONException
	{
		super.fromJson(jsonObj);
		
		//-- parse: meta_
		meta_ = new HashMap<String,String>();
		JSONObject jmeta = obj.getJSONObject("meta_");
		String[]   jmkeys = JSONObject.getNames(jmeta);
		for (String k : jmkeys) {
			if (k.equals("indices_")) { continue; }
			meta_.put(k, jmeta.optString(k));
		}
		
		//-- parse: indices_ , _index
		JSONArray jind = jmeta.getJSONArray("indices_");
		indices_       = new String[jind.length()];
		index_         = new HashMap<String,Integer>();
		for (int i=0; i < jind.length(); i++) {
			indices_[i] = jind.optString(i);
			index_.put(indices_[i],i);
		}
		
		//-- parse: context: left
		JSONArray jleft = obj.getJSONArray("ctx_").getJSONArray(0); 
		left_ = new String[jleft.length()];
		for (int i=0; i <  left_.length; i++) {
			left_[i] = jleft.optString(i);
		}

		//-- parse: context: match
		JSONArray jmatch = obj.getJSONArray("ctx_").getJSONArray(1); 
		match_ = new DDCHitToken[jmatch.length()];
		for (int i=0; i <  match_.length; i++) {
			match_[i] = new DDCHitToken(jmatch.getJSONArray(i));
		}

		//-- parse: context: right
		JSONArray jright = obj.getJSONArray("ctx_").getJSONArray(2); 
		right_ = new String[jright.length()];
		for (int i=0; i <  right_.length; i++) {
			right_[i] = jright.optString(i);
		}

	}

	// -----------------------------------------------------------------
	// DDCHitToken utilities
	
	/** get a token attribute value by name for a DDCHitToken from this.match_ */
	public String getTokenAttribute(DDCHitToken tok, String attrName)
	{ return tok.getAttribute(index_.get(attrName)); }
	
}
