package de.dwds.ddc.client;

import org.json.*;

/** base class for query responses from ddc server, used by DDCClient */
public class DDCJsonObject {
	//-----------------------------------------------------------------
	// properties (public, because private data is annoying)
	
	/** underlying JSONObject: public, because private data is annoying */
	public JSONObject obj;
	
	//-----------------------------------------------------------------
	// constructors etc
	
	/** default constructor */
	DDCJsonObject()
	{
		obj = null;
	}
	
	/** constructor from json string */
	DDCJsonObject(String jsonStr) throws JSONException
	{ this.fromJson(jsonStr); }

	/** constructor from json object*/
	DDCJsonObject(JSONObject jsonObj) throws JSONException
	{ this.fromJson(jsonObj); }

	//-----------------------------------------------------------------
	// parsing

	/** populate object by parsing ddc-2.x json response string */
	public void fromJson(String jsonStr) throws JSONException
	{ fromJson(new JSONObject(jsonStr)); }

	/** populate object by parsing ddc-2.x json response object;
	 *  really just sets obj=jsonObj.
	 *  child classes should override this method.
	 */
	public void fromJson(JSONObject jsonObj) throws JSONException
	{ obj = jsonObj; }
			
	// -----------------------------------------------------------------
	// stringification
	/** stringification just wraps obj.toString() */
	public String toString()
	{ return obj.toString(); }
}
