/** ddc client test program package */ 
package de.dwds.ddc.client.main;

import de.dwds.ddc.client.*;

/** simple request tester class using DDCSocket */
public class DDCQuery {

	/**
	 * @param args command-line arguments
	 */
	public static void main(String[] args) {
		//-- parse command-line
		if (args.length < 3) {
			System.err.println("Usage: java de.dwds.ddc.client.main.DDCQueryx SERVER PORT QUERY [OFFSET=0 [LIMIT=10 [TIMEOUT=60]]]");
			System.exit(1);
		}
		String ddcHost = args[0];
		int    ddcPort = Integer.parseInt(args[1]);
		String query   = args[2];		
		int offset = (args.length>3 ? Integer.parseInt(args[3]) : 0);
		int limit  = (args.length>4 ? Integer.parseInt(args[4]) : 10);
		int timeout = (args.length>5 ? Integer.parseInt(args[5]) : 60);
	
		try {
			//-- connect a DDC client & send user request			
			DDCClient dclient    = new DDCClient(ddcHost, ddcPort);
			DDCQueryResponse rsp = dclient.runQuery(query, offset, limit, timeout);		

			//System.out.println(rsp.toString()); //-- debug: dump raw json data

			//-- check for error response
			if (!rsp.isSuccess()) {
				System.err.println("Server Error from "+ddcHost + ":" + ddcPort + " ("+rsp.istatus_+"/"+rsp.nstatus_+"): "+rsp.error_);
				System.exit(1);
			}
			
			//-- fpormat response data
			System.out.print("# Hit(s) " + offset + "-" + (rsp.end_-1) + " of " + rsp.nhits_ + "\n");
			for (int i=0; i < rsp.hits_.length; i++) {
				DDCHit h = rsp.hits_[i];
				String basename = DDCUtils.fileBasename(h.meta_.get("file_"));
				
				System.out.print((offset+i) +" [" + basename +":" + h.meta_.get("page_")+"]");
				if (h.left_.length > 0) {
					for (String s : h.left_) {
						System.out.print(" "+s);
					}
				}

				for (DDCHitToken t : h.match_) {
					String hl = (t.isMatch() ? "__" : "");
					System.out.print(" "+hl+t.attrs_[0]+hl);
				}

				if (h.right_.length > 0) {
					System.out.print("\n\t");
					for (String s : h.right_) {
						System.out.print(" "+s);
					}
				}
				System.out.print("\n");
			}
			
			//-- cleanup
			dclient.close();
		} catch (Exception e) {
			System.err.println("Exception: " + e.toString());
			e.printStackTrace();
			System.exit(2);
		}

	}

}
