package example;

import java.io.FileNotFoundException;
import java.util.*;

import processing.core.PApplet;
import processing.core.PFont;
import wordcram.*;

public class Main extends PApplet {
	
	WordCram wordcram;
	
	String[] w1 = new String[] {"Buch","Tasche","Auto"};
	String[] w2 = new String[] {};
	String[] w3 = new String[] {};
	
	float[] l1 = new float[] {0.1f,0.4f,0.6f};
	float[] l2 = new float[] {0.4f,0.1f,0.6f};
	float[] l3 = new float[] {0.6f,0.4f,0.1f};
	Word[][] words1 = new Word[3][3];
	int next = 0;
	public void setup() {
		
		words1[0][0] = new Word(w1[0], l1[0]);
		words1[0][1] = new Word(w1[1], l1[1]);
		words1[0][2] = new Word(w1[2], l1[2]);
		
		words1[1][0] = new Word(w1[0], l2[0]);
		words1[1][1] = new Word(w1[1], l2[1]);
		words1[1][2] = new Word(w1[2], l2[2]);
		
		words1[2][0] = new Word(w1[0], l3[0]);
		words1[2][1] = new Word(w1[1], l3[1]);
		words1[2][2] = new Word(w1[2], l3[2]);

		// destination.image.getGraphics():
		// P2D -> sun.awt.image.ToolkitImage, JAVA2D -> java.awt.image.BufferedImage.

		// parent.getGraphics():
		// P2D -> sun.java2d.SunGraphics2D, JAVA2D -> same thing.

		// P2D can't draw to destination.image.getGraphics(). Interesting.

		size(700, 400); // (int)random(300, 800)); //1200, 675); //1600, 900);
		smooth();
		colorMode(HSB);
		try {
			initWordCram();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//frameRate(1);
	}
	
	private PFont randomFont() {
		String[] fonts = PFont.list();
		String noGoodFontNames = "Dingbats|Standard Symbols L";
		String blockFontNames = "OpenSymbol|Mallige Bold|Mallige Normal|Lohit Bengali|Lohit Punjabi|Webdings";
		Set<String> noGoodFonts = new HashSet<String>(Arrays.asList((noGoodFontNames+"|"+blockFontNames).split("|")));
		String fontName;
		do {
			fontName = fonts[(int)random(fonts.length)];
		} while (fontName == null || noGoodFonts.contains(fontName));
		System.out.println(fontName);
		return createFont(fontName, 1);
		//return createFont("Molengo", 1);
	}
	
	//PGraphics pg;
	private void initWordCram() throws FileNotFoundException {
		background(100);
		
		//pg = createGraphics(800, 600, JAVA2D);
		//pg.beginDraw();
		size(1000, 600);
		colorMode(HSB);
		background(230);

		// Make a wordcram from a random wikipedia page.
		wordcram = new WordCram(this);
		wordcram
		  //.fromWebPage("http://en.wikipedia.org/wiki/Special:Random")
		  .fromWords(words1[0])
		  .withColors(color(30), color(110),
		              color(random(255), 240, 200))
		  .sizedByWeight(5, 120)
		  .withFont("Copse")
		  .drawAll();
		Word w = new Word("Bach", 0.01f);		
		/*
		wordcram = new WordCram(this)
//					.toCanvas(pg)
					.fromTextFile(textFilePath())
//					.fromWords(alphabet())
//					.upperCase()
//					.excludeNumbers()
					.withFonts(randomFont())
					.withColorer(Colorers.twoHuesRandomSats(this))
//					.withColorer(Colorers.complement(this, random(255), 200, 220))
					.withAngler(Anglers.mostlyHoriz())
					.withPlacer(Placers.horizLine())
//					.withPlacer(Placers.centerClump())
					.withSizer(Sizers.byWeight(5, 90))
					.withWordPadding(1)
					
//					.minShapeSize(0)
//					.withMaxAttemptsForPlacement(10)
					.maxNumberOfWordsToDraw(1000)
					.toSvg("test.svg", 1000, 1000)
//					.withNudger(new PlottingWordNudger(this, new SpiralWordNudger()))
//					.withNudger(new RandomWordNudger())
					
					;*/
	}
	
	private void finishUp() {
		//pg.endDraw();
		//image(pg, 0, 0);
		
		//println(wordcram.getSkippedWords());
		
		println("Done");
		save("wordcram.png");
		noLoop();
	}
	
	public void draw() {
		//fill(55);
		//rect(0, 0, width, height);
		next = (next+1)%3;
		wordcram.fromWords(words1[next]);		
		boolean allAtOnce = true;
		if (allAtOnce) {
			wordcram.drawAll();
			finishUp();
		}
		else {
			int wordsPerFrame = 1;
			while (wordcram.hasMore() && wordsPerFrame-- > 0) {
				wordcram.drawNext();
			}
			
			if (!wordcram.hasMore()) {
				finishUp();
			}
		}
	}
	
	public void mouseMoved() {
		/*
		Word word = wordcram.getWordAt(mouseX, mouseY);
		if (word != null) {
			System.out.println(round(mouseX) + "," + round(mouseY) + " -> " + word.word);
		}
		*/
	}
		
	public void mouseClicked() {
		try {
			initWordCram();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		loop();
	}
	
	public void keyPressed() {
		if (keyCode == ' ') {
			saveFrame("wordcram-##.png");
		}
	}
	
	private String textFilePath() {
		return "../tao-te-ching.txt";
	}
	
	private Word[] alphabet() {
		Word[] w = new Word[26];
		for (int i = 0; i < w.length; i++) {
			w[i] = new Word(new String(new char[]{(char)(i+65)}), 26-i);
		}
		return w;
	}
}
